<div class="flex items-center justify-between">
  <h2 class="text-lg font-semibold"><?= e(t('menu.create')) ?></h2>
</div>

<?php if (!empty($ok)): ?>
  <div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>
<?php if (!empty($err)): ?>
  <div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<form method="post" class="mt-4 space-y-4">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

  <div class="grid grid-cols-1 gap-3 md:grid-cols-4">
    <div>
      <label class="text-sm">Tür</label>
      <select id="docType" name="type" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        <option value="invoice">Fatura</option>
        <option value="quote">Teklif</option>
      </select>
    </div>

    <div>
      <label class="text-sm">Belge No</label>
      <input id="docNo" name="doc_no" value="<?= e((string)($docNoInvoice ?? '')) ?>" placeholder="Örn: FTR-000001"
             class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
      <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Otomatik gelir, istersen elle değiştirebilirsin.</p>
    </div>

    <div>
      <label class="text-sm">Müşteri</label>
      <select name="customer_id" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950" required>
        <option value="">Seç</option>
        <?php foreach ($customers as $c): ?>
          <option value="<?= (int)$c['id'] ?>"><?= e((string)$c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="text-sm">Para Birimi</label>
      <div class="mt-1 grid grid-cols-2 gap-2">
        <input name="currency" value="<?= e((string)($settings['default_currency'] ?? 'TRY')) ?>" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
        <input name="currency_symbol" value="<?= e((string)($settings['default_currency_symbol'] ?? '₺')) ?>" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
      </div>
    </div>
  </div>

  <div class="grid grid-cols-1 gap-3 md:grid-cols-3">
    <div>
      <label class="text-sm">Tarih</label>
      <input type="date" name="issue_date" value="<?= e(date('Y-m-d')) ?>" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
    </div>
    <div>
      <label class="text-sm">Vade</label>
      <input type="date" name="due_date" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
    </div>
    <div>
      <label class="text-sm">Kargo</label>
      <div class="mt-1 grid grid-cols-2 gap-2">
        <select name="shipping_mode" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
          <option value="none">Yok</option>
          <option value="separate">Ayrı Toplam</option>
          <option value="line">Kalem Olarak</option>
        </select>
        <input name="shipping_amount" type="number" step="0.01" value="0" class="w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950">
      </div>
      <div class="mt-2">
        <label class="text-xs text-slate-500 dark:text-slate-400">Kargo KDV %</label>
        <input name="shipping_vat_rate" type="number" step="0.01" value="<?= e((string)($settings['default_vat_rate'] ?? '20')) ?>"
          class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950">
      </div>
      <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">
        “Kalem Olarak” seçersen kargoyu satır olarak eklersin (tavsiye). “Ayrı Toplam” seçersen aşağıdaki tutar toplamda ayrıca hesaplanır.
      </p>
    </div>
  </div>

  <!-- Kalemler -->
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="flex items-center justify-between">
      <div class="font-semibold">Kalemler</div>
      <button type="button" id="btnAdd" class="rounded-xl border border-slate-200 px-3 py-2 text-sm hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">
        + Satır Ekle
      </button>
    </div>

    <datalist id="productsList">
      <?php foreach ($products as $p): ?>
        <option value="<?= e((string)$p['name']) ?>"></option>
      <?php endforeach; ?>
    </datalist>

    <div class="mt-3 overflow-auto">
      <table class="min-w-full text-sm" id="itemsTable">
        <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
          <tr>
            <th class="py-2 pr-2">Ürün/Hizmet</th>
            <th class="py-2 pr-2">Açıklama</th>
            <th class="py-2 pr-2">Miktar</th>
            <th class="py-2 pr-2">Birim</th>
            <th class="py-2 pr-2">Birim Fiyat</th>
            <th class="py-2 pr-2">KDV %</th>
            <th class="py-2 pr-2 text-right">Tutar</th>
            <th class="py-2 pr-2"></th>
          </tr>
        </thead>
        <tbody id="itemsBody" class="divide-y divide-slate-100 dark:divide-slate-800"></tbody>
      </table>
    </div>

    <div class="mt-4 grid grid-cols-1 gap-2 md:grid-cols-3">
      <div class="rounded-xl border border-slate-200 px-3 py-2 dark:border-slate-800">
        <div class="text-xs text-slate-500 dark:text-slate-400">Ara Toplam</div>
        <div class="font-semibold" id="sumSubtotal">0.00</div>
      </div>
      <div class="rounded-xl border border-slate-200 px-3 py-2 dark:border-slate-800">
        <div class="text-xs text-slate-500 dark:text-slate-400">KDV Toplam</div>
        <div class="font-semibold" id="sumVat">0.00</div>
      </div>
      <div class="rounded-xl border border-slate-200 px-3 py-2 dark:border-slate-800">
        <div class="text-xs text-slate-500 dark:text-slate-400">Genel Toplam</div>
        <div class="font-semibold" id="sumGrand">0.00</div>
      </div>
    </div>
  </div>

  <div>
    <label class="text-sm">Notlar</label>
    <textarea name="notes" rows="3" class="mt-1 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-950"></textarea>
  </div>

  <button class="w-full rounded-xl bg-slate-900 px-4 py-2 text-white dark:bg-white dark:text-slate-900">
    Kaydet
  </button>
</form>

<script>
  const products = <?= json_encode($products, JSON_UNESCAPED_UNICODE) ?>;
  const docNoInvoice = <?= json_encode((string)($docNoInvoice ?? ''), JSON_UNESCAPED_UNICODE) ?>;
  const docNoQuote   = <?= json_encode((string)($docNoQuote ?? ''), JSON_UNESCAPED_UNICODE) ?>;

  const productByName = new Map(products.map(p => [String(p.name), p]));

  function rowTemplate(i){
    return `
      <tr data-idx="${i}">
        <td class="py-2 pr-2">
          <input list="productsList" name="items[${i}][name]" placeholder="Seç ya da yaz"
            class="w-56 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
          <div class="mt-1 text-[11px] text-slate-500 dark:text-slate-400">İpucu: Ürün adını seçersen alanlar otomatik dolar.</div>
        </td>

        <td class="py-2 pr-2">
          <input name="items[${i}][description]" placeholder="Açıklama"
            class="w-full rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
        </td>

        <td class="py-2 pr-2">
          <input name="items[${i}][qty]" type="number" step="0.001" value="1"
            class="w-28 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
        </td>

        <td class="py-2 pr-2">
          <input name="items[${i}][unit]" value="adet"
            class="w-24 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
        </td>

        <td class="py-2 pr-2">
          <input name="items[${i}][unit_price]" type="number" step="0.01" value="0"
            class="w-32 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
        </td>

        <td class="py-2 pr-2">
          <input name="items[${i}][vat_rate]" type="number" step="0.01" value="<?= e((string)($settings['default_vat_rate'] ?? '20')) ?>"
            class="w-24 rounded-lg border border-slate-200 bg-white px-2 py-2 dark:border-slate-800 dark:bg-slate-950">
        </td>

        <td class="py-2 pr-2 text-right">
          <span class="font-semibold" data-line-total>0.00</span>
          <input type="hidden" name="items[${i}][line_total]" value="0" data-line-total-input>
        </td>

        <td class="py-2 pr-2">
          <button type="button" class="btnDel rounded-lg border border-slate-200 px-3 py-2 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Sil</button>
        </td>
      </tr>
    `;
  }

  function n(v){
    const x = parseFloat(String(v ?? '').replace(',', '.'));
    return Number.isFinite(x) ? x : 0;
  }

  function fmt2(x){
    return (Number(x || 0).toFixed(2));
  }

  function recalc(){
    let sub = 0, vat = 0, grand = 0;

    document.querySelectorAll('#itemsBody tr').forEach(tr => {
      const i = tr.getAttribute('data-idx');

      const qty   = n(tr.querySelector(`[name="items[${i}][qty]"]`)?.value);
      const price = n(tr.querySelector(`[name="items[${i}][unit_price]"]`)?.value);
      const vr    = n(tr.querySelector(`[name="items[${i}][vat_rate]"]`)?.value);

      const lineSub = qty * price;
      const lineVat = lineSub * (vr / 100);
      const lineTot = lineSub + lineVat;

      sub += lineSub;
      vat += lineVat;
      grand += lineTot;

      const span = tr.querySelector('[data-line-total]');
      const inp  = tr.querySelector('[data-line-total-input]');
      if (span) span.textContent = fmt2(lineTot);
      if (inp)  inp.value = fmt2(lineTot);
    });

    // Kargo "Ayrı Toplam" ise toplamı ayrıca ekle (kalem olarak seçildiyse ekleme!)
    const shipMode = document.querySelector('[name="shipping_mode"]')?.value || 'none';
    const shipAmount = n(document.querySelector('[name="shipping_amount"]')?.value);
    const shipVatRate = n(document.querySelector('[name="shipping_vat_rate"]')?.value);

    if (shipMode === 'separate' && shipAmount > 0) {
      const shipVat = shipAmount * (shipVatRate / 100);
      sub += shipAmount;
      vat += shipVat;
      grand += (shipAmount + shipVat);
    }

    document.getElementById('sumSubtotal').textContent = fmt2(sub);
    document.getElementById('sumVat').textContent      = fmt2(vat);
    document.getElementById('sumGrand').textContent    = fmt2(grand);
  }

  let idx = 0;
  const body = document.getElementById('itemsBody');
  const btnAdd = document.getElementById('btnAdd');

  function bindRow(tr, i){
    const nameInp = tr.querySelector(`[name="items[${i}][name]"]`);
    const descInp = tr.querySelector(`[name="items[${i}][description]"]`);
    const unitInp = tr.querySelector(`[name="items[${i}][unit]"]`);
    const priceInp= tr.querySelector(`[name="items[${i}][unit_price]"]`);
    const vatInp  = tr.querySelector(`[name="items[${i}][vat_rate]"]`);
    const qtyInp  = tr.querySelector(`[name="items[${i}][qty]"]`);

    nameInp.addEventListener('input', () => {
      const p = productByName.get(String(nameInp.value || ''));
      if (!p) { recalc(); return; }
      if (p.description && (!descInp.value || descInp.value.trim()==='')) descInp.value = String(p.description);
      if (p.unit) unitInp.value = String(p.unit);
      if (p.price != null) priceInp.value = String(p.price);
      if (p.vat_rate != null) vatInp.value = String(p.vat_rate);
      recalc();
    });

    [descInp, unitInp, priceInp, vatInp, qtyInp].forEach(el => el.addEventListener('input', recalc));
    tr.querySelector('.btnDel').addEventListener('click', () => { tr.remove(); recalc(); });
  }

  function addRow(){
    const i = idx;
    body.insertAdjacentHTML('beforeend', rowTemplate(i));
    const tr = body.lastElementChild;
    bindRow(tr, i);
    idx++;
    recalc();
  }

  btnAdd.addEventListener('click', addRow);
  addRow();

  // Kargo ayarları değişince totals güncellensin
  document.querySelector('[name="shipping_mode"]')?.addEventListener('change', recalc);
  document.querySelector('[name="shipping_amount"]')?.addEventListener('input', recalc);
  document.querySelector('[name="shipping_vat_rate"]')?.addEventListener('input', recalc);

  // doc no auto swap
  const typeSel = document.getElementById('docType');
  const docNoInp = document.getElementById('docNo');
  typeSel.addEventListener('change', () => {
    const current = (docNoInp.value || '').trim();
    const autoInvoice = (docNoInvoice || '').trim();
    const autoQuote = (docNoQuote || '').trim();
    if (current === autoInvoice || current === autoQuote || current === '') {
      docNoInp.value = typeSel.value === 'quote' ? autoQuote : autoInvoice;
    }
  });
</script>
